//******************************************************************************
//
//	File:		InstantiateBButton.h
//
//	Description:	Unarchiving a BButton instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include <Button.h>
#include <string.h>

#pragma export on
BButton* InstantiateBButton(BMessage *message);
#pragma export off



BButton* InstantiateBButton(BMessage *message)
{
	BButton	*instance;						// returned pointer
	BRect	frame;							// view frame
	char	*label = NULL;
	bool	enabled;
	long	follow;							// resizing mode
	float	value;
	
	// Default values
	
	frame.left = 10;
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 30;
	label = strdup("Button");
	enabled = TRUE;
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;

	// Decode instance values
	
	if (message->HasPoint("Origin")) {						// Used when dropped
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasString("Label")) {
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	
	if (message->HasBool("Enabled")) {
		enabled = message->FindBool("Enabled");
	}	

	if (label == NULL) label = strdup("Button");

	instance = new BButton(frame,"BButton",label,NULL,follow);

	if (message->HasString("Font Name")) {
		instance->SetFontName(message->FindString("Font Name"));
	}	
		
	instance->SetEnabled((bool)enabled);
	free(label);

	return instance;
}